<?php
/**
 * @var $module
 * @var $settings
 * @var $id
 */

$settings = apply_filters('labb_icon_list_' . $id . '_settings', $settings);

list($animate_class, $animation_attr) = labb_get_animation_atts($settings->icon_animation);

$output = '<div class="labb-icon-list labb-align' . $settings->align . '">';

foreach ($settings->icon_list as $icon_item):

    if (!is_object($icon_item))
        continue;

    $icon_type = esc_html($icon_item->icon_type);

    $icon_title = esc_html($icon_item->icon_title);

    $icon_url = isset($icon_item->icon_link) ? $icon_item->icon_link : null;

    $target = ($settings->new_window == 'yes') ? 'target="_blank"' : '';

    $child_output = '<div class="labb-icon-list-item ' . $animate_class . '" ' . $animation_attr . ' title="' . $icon_title . '">';

    if (($icon_type == 'icon_image') && !empty($icon_item->icon_image)) :

        if (empty($icon_url)) :

            $child_output .= '<div class="labb-image-wrapper">';

            $child_output .= wp_get_attachment_image($icon_item->icon_image, 'full', false, array('class' => 'labb-image full', 'alt' => $icon_title));

            $child_output .= '</div>';

        else :

            $child_output .= '<a class="labb-image-wrapper" href="' . $icon_url . '" ' . $target . '>';

            $child_output .= wp_get_attachment_image($icon_item->icon_image, 'full', false, array('class' => 'labb-image full', 'alt' => $icon_title));

            $child_output .= '</a>';

        endif;

    else :

        if (empty($icon_url)) :

            $child_output .= '<div class="labb-icon-wrapper">';

            $child_output .= '<span class="' . esc_attr($icon_item->font_icon) . '"></span>';

            $child_output .= '</div>';

        else :

            $child_output .= '<a class="labb-icon-wrapper" href="' . $icon_url . '" ' . $target . '>';

            $child_output .= '<span class="' . esc_attr($icon_item->font_icon) . '"></span>';

            $child_output .= '</a>';

        endif;

    endif;

    $child_output .= '</div><!-- .labb-icon-list-item -->';

    $output .= apply_filters('labb_icon_list_item_output', $child_output, $icon_item, $settings);

endforeach;

$output .= '</div><!-- .labb-icon-list -->';

echo apply_filters('labb_icon_list_output', $output, $settings);